var slideshowController = new TKPageSliderController({
  id: 'slideshow',
  previousPageButton : '#left_arrow',
  nextPageButton : '#right_arrow',
  backButton : '#close_button',
  activatesFocusedPage: true
});

slideshowController.viewWillAppear = function () {
  // set default index to 0
  photosController.photoIndex = photosController.photoIndex || 0;

  // show photo that was selected in the photos controller
  this.highlightedPageIndex = photosController.photoIndex;
  
  hasZoomed = true;
  
  // set up auto-hiding buttons
  this.activity = new createHovers(slideshowController._view);  
};

slideshowController.viewDidLoad = function () {
  this.slidingViewData = {
    orientation: TKSlidingViewOrientationHorizontal,
    activeElementIndex: 0,
    sideElementsVisible: 2,
    distanceBetweenElements: 1280,  
    sideOffsetBefore: 0,
    sideOffsetAfter: 0, 
    incrementalLoading: true,
    loops: true,
    elements: this.createPhotos()
  };
};

slideshowController.createPhotos = function () {
  var elements = [];
  for (var i = 1; i <= appData.numberOfPhotos; i++) {
    var padded_index = (i < 10) ? '0' + i : i;
	
	if(IS_APPLE_TV)var url = 'images/photos/photo' + padded_index + '_slideshow_ATV.jpg';
else var url = 'images/photos/photo' + padded_index + '_slideshow.jpg';
    elements.push({ 
      type: 'container',
      children: [ {type: 'image', src: url } ]
    });
  }
  return elements;
};

slideshowController.viewDidDisappear = function () {
  this.activity.disable();
};

slideshowController.pageWasHighlighted = function () {
  // keep photos controller in sync
  photosController.highlightedPageIndex = slideshowController.highlightedPageIndex;
};

function createHovers(wrapper) {
  this.wrapper = wrapper;
  this.elementClass = 'hoverable';
  this.lastMovement =  0;
  this.active = false;
  this.timerSet = false;
  this.timeout = 1000;
  this.sentMoveNotification = false;
  this.active = true;
  this.sentMoveNotification = false;
  document.addEventListener("mousemove", this, false);
};

createHovers.prototype.resetTime = function () {
  this.lastMovement = new Date();
};

createHovers.prototype.disable = function () {
  // stop watching for mouse movement
  if(!this.wrapper.hasClassName('activity-hidden')) this.wrapper.addClassName('activity-hidden');
  document.removeEventListener("mousemove", this);
  this.active = false;
};

createHovers.prototype.handleEvent = function (event) {
  if (event.target.hasClassName(this.elementClass) || typeof(event.target.parentNode.hasClassName) != 'function' || (event.target.parentNode.hasClassName(this.elementClass))) {
    this.active = false;
    this.timerSet = false;
    return;
  }
  this.active = true;
  this.resetTime();
  if (!this.sentMoveNotification) {
    this.sentMoveNotification = true;
    this.wrapper.removeClassName('activity-hidden');
  }
  if (!this.timerSet) {
    this.timerSet = true;
    var _this = this;
    setTimeout(function() {
      _this.testForNotification();
    }, this.timeout);
  }
};

createHovers.prototype.testForNotification = function () {
  if (!this.active) {
    return;
  }
  
  var now = new Date();
  var timeSinceLastMovement = now - this.lastMovement;
  
  if (timeSinceLastMovement > this.timeout) {
    // time has passed since we moved - notify the listener
    this.wrapper.addClassName("activity-hidden");
    this.sentMoveNotification = false;
    this.timerSet = false;
  } else {
    // not enough time has passed (mouse probably moved in the meantime)
    // test again after the appropriate gap
    var _this = this;
    setTimeout(function() {
      _this.testForNotification();
    }, (this.timeout - timeSinceLastMovement));
    this.timerSet = true;
  }
};
